/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.mysql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jtbcore.db.model.ColumnModel;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.IndexModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.mysql.MysqlConnection;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.model.BaseStringMap;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;

public class MysqlTableModelGenerator {
    protected DatabaseModel model;
    protected List<String> updateQueries;

    public MysqlTableModelGenerator() {
    }

    public MysqlTableModelGenerator(DatabaseModel model) {
        this.setModel(model);
    }

    public DatabaseModel getModel() {
        return this.model;
    }

    public void setModel(DatabaseModel model) {
        this.model = model;
    }

    public String generateCreateTable(String tableName) {
        TableModel tm = this.getModel().getTable(tableName);
        List<ColumnModel> cols = tm.getColumns();
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE ");
        b.append("`" + tm.getName() + "`");
        b.append(" (\n");
        int cnt = 0;
        for (ColumnModel cm : cols) {
            String type = this.dbtype(cm.getType());
            b.append("    `").append(cm.getName()).append("` ").append(type);
            if (cm.isPrimaryKey()) {
                b.append(" PRIMARY KEY ");
            }
            if (cm.isUnique()) {
                b.append(" UNIQUE ");
            }
            if (cm.isAutoIncrement()) {
                b.append(" AUTO_INCREMENT ");
            }
            if (cnt < cols.size() - 1) {
                b.append(",");
            }
            b.append("\n");
            ++cnt;
        }
        for (IndexModel im : tm.getIndexes()) {
            String str;
            if (im.getUnique().booleanValue()) {
                str = ", CONSTRAINT " + im.getName() + " UNIQUE INDEX ";
                str = str + " (" + StringUtil.join(", ", im.getFields()) + ") ";
                b.append(str);
                b.append("\n");
                continue;
            }
            str = ", INDEX" + im.getName();
            str = str + " (" + StringUtil.join(", ", im.getFields()) + ") ";
            b.append(str);
            b.append("\n");
        }
        b.append(")\n");
        return b.toString();
    }

    public String generateAddColumn(String tableName, ColumnModel cm) {
        String sql = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + cm.getName() + "` " + this.dbtype(cm.getType());
        return sql;
    }

    public List<TableModel> updateSchema(MysqlConnection con) throws SQLException, IOException {
        TableModel tm;
        ArrayList<TableModel> updatedTables = new ArrayList<TableModel>();
        this.updateQueries = new ArrayList<String>();
        Map<String, TableModel> tablesModel = this.model.getTables();
        SqlDatabase sqlDb = this.mysqlToSqlDatabaseModelOnly(con);
        for (String tblInModel : tablesModel.keySet()) {
            if (sqlDb.getTable(tblInModel) != null || !(tm = tablesModel.get(tblInModel)).isAutogenerated()) continue;
            String sqlCreate = this.generateCreateTable(tblInModel);
            this.updateQueries.add(sqlCreate);
            if (updatedTables.contains(tm)) continue;
            updatedTables.add(tm);
        }
        for (SqlTable st : sqlDb.getTables()) {
            tm = tablesModel.get(st.getName());
            if (tm == null) continue;
            for (ColumnModel cm : tm.getColumns()) {
                if (st.getColumnByName(cm.getName()) != null) continue;
                String sqlAdd = this.generateAddColumn(tm.getName(), cm);
                System.out.println(sqlAdd);
                this.updateQueries.add(sqlAdd);
                if (updatedTables.contains(tm)) continue;
                updatedTables.add(tm);
            }
        }
        for (String q : this.updateQueries) {
            con.query(q, new Object[0]);
        }
        return updatedTables;
    }

    public SqlTable mysqlToSqlTable(MysqlConnection con, String tblName) throws IOException, SQLException {
        List cols = con.queryList("describe `" + tblName + "`", new Object[0]);
        SqlTable table = new SqlTable(tblName);
        for (BaseStringMap col : cols) {
            String strlen;
            Integer len;
            boolean isAutoincrement = false;
            if (col.getProperty("Extra") != null && col.getProperty("Extra").indexOf("auto_increment") != -1) {
                isAutoincrement = true;
            }
            SqlColumn scol = new SqlColumn();
            scol.name = col.getProperty("Field");
            scol.sqlDatatype = col.getProperty("Type");
            scol.primaryKey = col.getProperty("Key") != null && col.getProperty("Key").indexOf("PRI") != -1;
            scol.autoincrement = isAutoincrement;
            if (scol.sqlDatatype.contains("varchar(") && (len = NumberUtil.tryParseInt(strlen = scol.sqlDatatype.replaceAll("^.*\\(\\D*(\\d+).*$", "$1"))) != null) {
                scol.maxLen = len;
            }
            scol.internalType = this.internalDataType(col.getProperty("Type"));
            table.setColumn(scol);
        }
        return table;
    }

    public SqlDatabase mysqlToSqlDatabaseModelOnly(MysqlConnection con) throws IOException, SQLException {
        String databaseName = con.getDatabaseName();
        SqlDatabase db = new SqlDatabase();
        for (TableModel tm : this.model.getTables().values()) {
            List recs = con.queryList("select * from information_schema.tables  where table_schema = ? \tand table_name = ?", databaseName, tm.getName());
            if (recs.size() <= 0) continue;
            SqlTable st = this.mysqlToSqlTable(con, tm.getName());
            db.addTable(st);
        }
        return db;
    }

    public SqlDatabase mysqlToSqlDatabase(MysqlConnection con) throws IOException, SQLException {
        String databaseName = con.getDatabaseName();
        List recTables = con.queryList("select table_name  from information_schema.tables  where table_schema = ? \tand table_type='BASE TABLE' ", databaseName);
        SqlDatabase db = new SqlDatabase();
        for (BaseStringMap recTbl : recTables) {
            String tblName = recTbl.getProperty("table_name");
            SqlTable table = this.mysqlToSqlTable(con, tblName);
            db.addTable(table);
        }
        return db;
    }

    public SqlColumn.DataType internalDataType(String dataType) {
        if ((dataType = dataType.toLowerCase()).startsWith("varchar") || dataType.startsWith("char") || dataType.indexOf("text") != -1 || dataType.indexOf("enum") != -1) {
            return SqlColumn.DataType.TEXT;
        }
        if (dataType.indexOf("binary") != -1 || dataType.indexOf("blob") != -1) {
            return SqlColumn.DataType.TEXT;
        }
        if (dataType.indexOf("int") != -1 || dataType.indexOf("bool") != -1) {
            return SqlColumn.DataType.NUMERIC;
        }
        if (dataType.indexOf("float") != -1 || dataType.indexOf("double") != -1 || dataType.indexOf("decimal") != -1) {
            return SqlColumn.DataType.REAL;
        }
        if (dataType.indexOf("date") != -1 || dataType.indexOf("timestamp") != -1) {
            return SqlColumn.DataType.DATE;
        }
        return SqlColumn.DataType.TEXT;
    }

    public String dbtype(String modelType) {
        if ((modelType = modelType.toLowerCase()).startsWith("varchar")) {
            return modelType;
        }
        if ("text".equals(modelType)) {
            return "text";
        }
        if ("longtext".equals(modelType)) {
            return "longtext";
        }
        if ("bool".equals(modelType) || "boolean".equals(modelType)) {
            return "tinyint";
        }
        if ("int".equals(modelType) || "int32".equals(modelType)) {
            return "int";
        }
        if ("int64".equals(modelType) || "bigint".equals(modelType) || "long".equals(modelType)) {
            return "bigint";
        }
        if ("double".equals(modelType)) {
            return "double";
        }
        if ("float".equals(modelType)) {
            return "float";
        }
        if ("blob".equals(modelType)) {
            return "BLOB";
        }
        if ("datetime".equals(modelType)) {
            return "datetime";
        }
        if ("date".equals(modelType)) {
            return "date";
        }
        return "text";
    }

    public static void main(String[] args) {
    }
}

